/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.kubejs;

import com.almostreliable.summoningrituals.altar.AltarEntity;
import com.almostreliable.summoningrituals.compat.kubejs.AltarRecipeJS;
import com.almostreliable.summoningrituals.compat.kubejs.SummoningEventJS;
import com.almostreliable.summoningrituals.recipe.component.RecipeOutputs;
import com.almostreliable.summoningrituals.util.SerializeUtils;
import com.almostreliable.summoningrituals.util.TextUtils;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class AlmostKube
extends KubeJSPlugin {
    public void init() {
        AltarEntity.SUMMONING_START.register((level, pos, recipe, player) -> {
            SummoningEventJS event = new SummoningEventJS(true, level, pos, recipe, player);
            event.post(ScriptType.SERVER, TextUtils.f("{}.start", "summoningrituals"));
            return !event.isCancelled();
        });
        AltarEntity.SUMMONING_COMPLETE.register((level, pos, recipe, player) -> {
            new SummoningEventJS(false, level, pos, recipe, player).post(ScriptType.SERVER, TextUtils.f("{}.complete", "summoningrituals"));
            return true;
        });
    }

    public void addBindings(BindingsEvent event) {
        if (event.type != ScriptType.SERVER) {
            return;
        }
        event.add("SummoningOutput", OutputWrapper.class);
    }

    public void addTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        if (type != ScriptType.SERVER) {
            return;
        }
        typeWrappers.register(RecipeOutputs.ItemOutputBuilder.class, OutputWrapper::item);
        typeWrappers.register(RecipeOutputs.MobOutputBuilder.class, OutputWrapper::mob);
    }

    public void addRecipes(RegisterRecipeHandlersEvent event) {
        event.register(TextUtils.getRL("altar"), AltarRecipeJS::new);
    }

    public static final class OutputWrapper {
        private OutputWrapper() {
        }

        public static RecipeOutputs.ItemOutputBuilder item(@Nullable Object o) {
            if (o instanceof RecipeOutputs.ItemOutputBuilder) {
                RecipeOutputs.ItemOutputBuilder iob = (RecipeOutputs.ItemOutputBuilder)o;
                return iob;
            }
            ItemStackJS stack = ItemStackJS.of((Object)o);
            if (stack.isEmpty()) {
                ConsoleJS.SERVER.error((Object)"ItemStack is empty or null");
            }
            return new RecipeOutputs.ItemOutputBuilder(stack.getItemStack());
        }

        public static RecipeOutputs.MobOutputBuilder mob(@Nullable Object o) {
            if (o instanceof RecipeOutputs.MobOutputBuilder) {
                RecipeOutputs.MobOutputBuilder mob = (RecipeOutputs.MobOutputBuilder)o;
                return mob;
            }
            if (o instanceof CharSequence || o instanceof ResourceLocation) {
                ResourceLocation id = ResourceLocation.m_135820_((String)o.toString());
                EntityType<?> mob = SerializeUtils.mobFromId(id);
                return new RecipeOutputs.MobOutputBuilder(mob);
            }
            ConsoleJS.SERVER.error((Object)"Missing or invalid entity given for SummoningEntityOutput");
            return new RecipeOutputs.MobOutputBuilder(EntityType.f_20461_);
        }
    }
}

